# Number of Good Components
## Medium
<div class="problems_problem_content__Xm_eO"><p><span style="font-size:18px">Given an undirected graph with <strong>V </strong>vertices(numbered from <strong>1</strong> to <strong>V</strong>) and <strong>E </strong>edges. Find the number of good components in the graph.<br>
A component of the graph is good if and only if the component is a fully connected component.<br>
<strong>Note:&nbsp;</strong>A fully connected component&nbsp;is a subgraph of a given graph such that there's an&nbsp;edge between every pair of vertices in a component, the given graph can be a&nbsp;<strong>disconnected graph. </strong>Consider the adjacency list from index <strong>1</strong>.</span></p>

<p><strong><span style="font-size:18px">Example 1:</span></strong></p>

<pre><strong><span style="font-size:18px">Input: 
<img alt="" src="https://media.geeksforgeeks.org/img-practice/good_comp_1-1656905170.png" style="height:239px; width:350px">
Output: </span></strong><span style="font-size:18px">1</span><strong><span style="font-size:18px">
Explanation: </span></strong><span style="font-size:18px">We can see that there is only one 
component in the graph and in this component 
there is a edge between any two vertces</span><strong><span style="font-size:18px">.</span></strong></pre>

<p><strong><span style="font-size:18px">Example 2:</span></strong></p>

<pre><span style="font-size:18px"><strong>Input:
</strong></span><img src="data:image/png;base64,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"><span style="font-size:18px"><strong>
Output: </strong>2<strong>
</strong></span><strong><span style="font-size:18px">Explanation: </span></strong><span style="font-size:18px">We can see that there are 3 components
in the graph. For 1-2-7 there is no edge between
1 to 7, so it is not a fully connected component.
Rest 2 are individually fully connected component.</span></pre>

<p><span style="font-size:18px"><strong>Your Task:</strong><br>
You don't need to read input or print anything. Your task is to complete the function<br>
<strong>findNumberOfGoodComponent() </strong>which takes an integer <strong>V </strong>and an adjacency list <strong>adj </strong>as input parameters and returns an integer denoting the number of good components. </span></p>

<p><span style="font-size:18px"><strong>Expected Time Complexity:</strong>&nbsp;O(V+E)<br>
<strong>Expected Auxiliary Space:</strong>&nbsp;O(depth of the graph)</span></p>

<p><span style="font-size:18px"><strong>Constraints:</strong><br>
1 ≤ V, E ≤ 10<sup>4</sup></span></p>
</div>